import React from 'react';
import { LayoutDashboard, Package, FileText, ShoppingCart, Users, Tags, Truck, UserCog, BarChart3, LogOut, User as UserIcon, Settings } from 'lucide-react';
import { User } from '../types';

interface SidebarProps {
  currentTab: string;
  setCurrentTab: (tab: string) => void;
  onLogout: () => void;
  currentUser: User | null;
}

export const Sidebar: React.FC<SidebarProps> = ({ currentTab, setCurrentTab, onLogout, currentUser }) => {
  const menuItems = [
    { id: 'dashboard', label: 'لوحة التحكم', icon: LayoutDashboard },
    { id: 'sales', label: 'المبيعات (POS)', icon: ShoppingCart },
    { id: 'invoices', label: 'سجل الفواتير', icon: FileText },
    { id: 'reports', label: 'تقارير المبيعات', icon: BarChart3 },
    { id: 'inventory', label: 'إدارة المخزون', icon: Package },
    { id: 'customers', label: 'العملاء', icon: Users },
    { id: 'suppliers', label: 'الموردين', icon: Truck },
    { id: 'categories', label: 'التصنيفات', icon: Tags },
    { id: 'users', label: 'المستخدمين', icon: UserCog },
    { id: 'settings', label: 'الإعدادات', icon: Settings },
  ];

  return (
    <div className="w-64 bg-slate-900 text-white flex flex-col h-screen fixed right-0 top-0 shadow-xl z-10">
      <div className="p-6 border-b border-slate-700">
        <h1 className="text-2xl font-bold flex items-center gap-2">
          <span className="text-emerald-400">مخزوني</span> برو
        </h1>
        <p className="text-xs text-slate-400 mt-1">نظام الإدارة المتكامل</p>
      </div>
      
      <nav className="flex-1 p-4 space-y-2 overflow-y-auto">
        {menuItems.map((item) => {
          const Icon = item.icon;
          return (
            <button
              key={item.id}
              onClick={() => setCurrentTab(item.id)}
              className={`w-full flex items-center gap-3 px-4 py-3 rounded-lg transition-all duration-200 ${
                currentTab === item.id
                  ? 'bg-emerald-600 text-white shadow-lg'
                  : 'text-slate-300 hover:bg-slate-800 hover:text-white'
              }`}
            >
              <Icon size={20} />
              <span className="font-medium">{item.label}</span>
            </button>
          );
        })}
      </nav>

      <div className="p-4 border-t border-slate-700">
        <div className="flex items-center gap-3 mb-4 px-2">
          <div className="w-8 h-8 rounded-full bg-slate-700 flex items-center justify-center">
            <UserIcon size={16} className="text-slate-300" />
          </div>
          <div className="overflow-hidden">
             <p className="text-sm font-medium text-white truncate">{currentUser?.fullName || 'مستخدم'}</p>
             <p className="text-xs text-slate-400 truncate">{currentUser?.role === 'admin' ? 'مدير النظام' : 'موظف'}</p>
          </div>
        </div>
        <button 
          onClick={onLogout}
          className="w-full flex items-center justify-center gap-2 bg-red-600/10 text-red-400 hover:bg-red-600 hover:text-white px-4 py-2 rounded-lg transition-all duration-200"
        >
          <LogOut size={18} />
          <span>تسجيل خروج</span>
        </button>
      </div>
    </div>
  );
};